<?php 
	error_reporting(E_ALL);
	ini_set('display_errors', 1);
	
	include '../inc/config.php';
	include '../inc/functions.php';
	
	$ip = getIP();
	
	if(!in_array($ip, $allowed_ips)){
		show_error_and_log($logfolder, "setUsernameLeerling opgevraagd vanuit niet toegelaten IP $ip");
		exit;
	}
	
	if(!isset($_GET['pointer']) || strlen($_GET['pointer']) < 1){
		show_error_and_log($logfolder, "setUsernameLeraar opgevraagd zonder pointer van de leraar");
		exit;
	}
	
	if(!isset($_GET['oude_gebruikersnaam']) && strlen($_GET['oude_gebruikersnaam']) > 1){
		show_error_and_log($logfolder, "setUsernameLeerling opgevraagd zonder de oude gebruikersnaam van de leerling");
		exit;
	}
	
	if(!isset($_GET['session_hash']) || strlen($_GET['session_hash']) != 64){
		show_error_and_log($logfolder, "setUsernameLeerling opgevraagd vanuit toegelaten IP $ip maar zonder (geldige) session_hash");
		exit;
	}
	
	
	if(!isset($_GET['lerarenid']) || !is_numeric($_GET['lerarenid'])){
		show_error_and_log($logfolder, "setUsernameLeerling opgevraagd vanuit toegelaten IP $ip maar zonder (geldige) lerarenid");
		exit;
	}
		
				
	$pointer 			 = $_GET['pointer'];
	$session_hash   	 = $_GET['session_hash']; 
	$lerarenid	    	 = $_GET['lerarenid'];
	$oude_gebruikersnaam = $_GET['oude_gebruikersnaam'];
	
	$verify_url = $toolbox_url.'/public/validate_ad_setusername_leerling_bs.php?session_hash='.$session_hash.'&key='.$ad_key.'&pointer='.$pointer;
	
	$return = file_get_contents($verify_url);				
	$return = json_decode($return);
	
	if(!is_object($return)){
		show_error_and_log($logfolder, "Geen geldige return waarde (geen object) voor setUsernameLeerling");
		exit;
	}	

	if(!property_exists($return, 'lerarenid')){
		show_error_and_log($logfolder, "Geen geldige return waarde (geen lerarenid) voor setUsernameLeerling");
		exit;
	}	
	
	if($return->lerarenid != $lerarenid){					
		show_error_and_log($logfolder, "Geen geldige return waarde (geen lerarenid) voor setUsernameLeerling");
		exit;
	}
	$gebruikersnaam		= $return->gebruikersnaam;
	$empnr			= $return->pointer;	
	$samaccountname 	= substr($oude_gebruikersnaam,0, 20);
	$newsamaccountname 	= substr($return->nieuwe_gebruikersnaam,0, 20);
	$name 				= str_replace('"', '', $return->voornaam.' '.$return->naam);
	$givenname 			= str_replace('"', '', $return->voornaam);
	$surname 			= str_replace('"', '', $return->naam);
	$displayname 		= str_replace('"', '', $return->displayname);
	$userprincipalname  = $return->adgebruikersnaam;

	$arr_data = array();
	exec("powershell -file C:\\toolbox\\powershell\\setUsername.ps1 -samaccountname \"$samaccountname\" -userid \"$gebruikersnaam\" -empnr \"$empnr\" -newsamaccountname \"$newsamaccountname\" -newupn \"$userprincipalname\" -name \"$displayname\" -givenname \"$givenname\" -surname \"$surname\" -displayname \"$displayname\"",$arr_data);
	
	if(count($arr_data) == 0){
		log_to_file($logfolder, "setUsernameLeerling uitgevoerd voor $samaccountname door lerarenid $lerarenid vanuit ip $ip");
		echo "1";
	}
	else{
		log_to_file($logfolder, "setUsernameLeerling niet uitgevoerd voor $samaccountname door lerarenid $lerarenid vanuit ip $ip: ".serialize(json_encode($arr_data)));
		echo json_encode($arr_data);
	}

?>